#version 130
#extension GL_EXT_gpu_shader4 : enable
// the version and open GL extension
// should be the first line of the shader
/////////////////////////////////////////////////////////////////////////////////
// Basic RaymarcherMod01.fsh  by  Xor  
//https://www.shadertoy.com/view/7ldfzj
//Licence : Creative Commons Attribution-ShareAlike 4.0
//http://creativecommons.org/licences/by-sa/4.0
// Adapted, trivialy, for use in VGHD player
/////////////////////////////////////////////
uniform float u_Elapsed;    // The elapsed time in seconds
uniform vec2  u_WindowSize; // Window dimensions in pixels

#define iTime u_Elapsed*0.314159  //*0.1666
#define iResolution u_WindowSize

//#define mouse AUTO_MOUSE
//#define MOUSE_SPEED vec2(vec2(0.5,0.577777) * 0.25)
//#define MOUSE_POS   vec2((1.0+cos(iTime*MOUSE_SPEED))*u_WindowSize/2.0)
//#define MOUSE_PRESS vec2(0.0,0.0)
//#define AUTO_MOUSE  vec4( MOUSE_POS, MOUSE_PRESS )
//#define RIGID_SCROLL
// alternatively use static mouse definition
#define iMouse vec4(0.0,0.0, 0.0,0.0)
//#define iMouse vec4(512,256,180,120)
uniform sampler2D texture0;
uniform sampler2D texture1;
uniform sampler2D texture2;
uniform sampler2D texture3;
vec4 texture2D_Fract(sampler2D sampler,vec2 P) {return texture2D(sampler,fract(P));}
vec4 texture2D_Fract(sampler2D sampler,vec2 P, float Bias) {return texture2D(sampler,fract(P),Bias);}
#define texture2D texture2D_Fract

/*
    "Xor's Basic Raymarcher" by @XorDev

    This is a little guide on raymarching to go along with my mini tutorial series:
    https://mini.gmshaders.com
*/

//Raymarcher "Epsilon" meaning how close to the surface we need to get to stop the loop
#define EPS 0.001
//Max distance to travel before we stop the loop
#define MAX 50.0
//Light direction vector
#define LIGHT normalize(vec3(1,3,-1))
//Gamma for gamma correction
#define GAMMA 2.2

//Distance field function
float dist(vec3 p)
{
    //Distance to ground floor
    float ground = p.y+1.0;
    //Basic repeating torus SDF
    float torus = length(vec2(length(p.xy)-0.8, mod(p.z,8.0)-4.0))-0.2;
    
    //Repeat XY axes for boxes
    p.xz = mod(p.xz, 4.0)-2.0;
    //Shift downward
    p.y += 0.3;
    //Compute distance using rounded box formula
    float box = length(max(abs(p)-0.4,-0.1))-0.2;
    
    return min(ground, min(torus, box)); //Return the closest of them all
}
//Compute normal from the distance field
vec3 normal(vec3 p)
{
    //Signed epsilon for computing distance field derivative
    const vec2 e = vec2(2, -2) * EPS;
    
    //Basically we're offsetting by slight amounts and computing rate of change.
    //This tells us which direction is most positive and then we normalize the vector.
    return normalize(dist(p+e.xxy)*e.xxy + dist(p+e.xyx)*e.xyx + dist(p+e.yxx)*e.yxx + dist(p+e.y)*e.y);
}
//Basic raymarching function
vec4 raymarch(vec3 pos, vec3 dir)
{
	float d = 0.0; //Starting distance

	for(int i = 0; i<200; i++) //Step 200 times
	{
		float step_dist = dist(pos + dir * d); //Check distance field
		d += step_dist; //March forward
		if (step_dist<EPS || d>MAX) break; //Stop at intersection or max distance

	}
	return vec4(pos + dir * d, d); //Return intersection point and distance

}
//Basic soft shadow function
float shadow(vec3 pos, vec3 dir, float mx)
{
    float d = 0.01; //Starting distance
    float s = 1.0; //Shadow value

	for(int i = 0; i<40; i++) // Step 40 times
	{
		float step_dist = dist(pos + dir * d); //Check distance field
		d += step_dist; //March forward
        
        
		if (step_dist<EPS) return 0.0; //Stop at intersection
        if (d>mx) break; //Stop at max distance
        s = min(s, step_dist / d * 5.0); //Brightness from proximity

	}
	return s; //Return shadow brightness
}
//Sample color at any given point
vec3 color(vec3 pos, vec3 dir, float dep)
{
    //Get normal
    vec3 n = normal(pos);
    
    //Coloring and checkerboard pattern
    vec3 cell = ceil(pos*3.);
    float checker = mod(cell.x+cell.y+cell.z, 2.0);
    vec3 col = pow(1.0 - vec3(0,.6,.8)*checker, vec3(GAMMA));
    
    //Dot product lighting
    float light = dot(n, LIGHT);
    //Fade to black
    light = max(light, 0.1+light*0.1);
    
    //Shadow raymarching
    float shade = shadow(pos, LIGHT, MAX)*0.9+0.1;
    //Blend the shading together with ambient light
    vec3 amb = pow(vec3(0.01,0.2,0.3), vec3(GAMMA));
    col *= mix(amb, vec3(1), min(light, shade));
    
    //Compute sky color using simple gradient
    vec3 sky = pow(vec3(0.2, 0.5, 0.8) * (1.0+dot(dir, LIGHT)), vec3(GAMMA));
    //Fade to background sky color
    col = mix(col, sky, smoothstep(0.0, MAX, dep));
    
    //Set color from dot lighting
    return col;
}
//void mainImage( out vec4 fragColor, in vec2 fragCoord )
///////////////////////////////////////////////////////////////////////////////// 
// need to convert this from a void to a function and call it by adding
// a void main(void) { to the end of the shader
// what type of variable will the function return?, it is a color and needs to be a vec4
// change void to vec4 
//void MainImage(out vec4 fragColor, in vec2 fragCoord) 
vec4 mainImage( out vec4 fragColor, in vec2 fragCoord )
{ 
    //Camera position (scrolling forward)
    vec3 p = vec3(0,0,iTime);
    //Ray direction
    vec3 d = normalize(vec3(fragCoord-.5*iResolution.xy,iResolution.y));
    
    //Find raymarch intersection
    vec4 m = raymarch(p, d);
    //Find color at intersection
    vec3 c = color(m.xyz, d, m.w);
    
    c = pow(c, vec3(1.0/GAMMA));
        
    //Output color
    fragColor = vec4(c, 1.0);
/////////////////////////////////////////////////////////////////////////////////
//the function needs to return a value. 
//it needs to be a vec4
//we will return the varable fragColor 
// usual place for fragColor = vec4( color, 1.0 ); bring the } down below 
return fragColor; 
}

///////////////////////////////////////////////////////////////////////////////// 
void main(void) { // this will be run for every pixel of gl_FragCoord.xy
vec4 vTexCoord = gl_TexCoord[0];
vec4 fragColor = vec4(1.0); // initialize variable fragColor as a vec4 
vec4 cc = mainImage(fragColor, gl_FragCoord.xy); // call function mainImage and assign the return vec4 to cc
gl_FragColor = vec4(cc) * gl_Color; // set the pixel to the value of vec4 cc  and..
//gl_FragColor.a = length(gl_FragColor.rgb);
}

// ..uses the values of any Color: or Opacity:
// clauses (and any Animate clauses applied to these properties) 
// appearing in the Sprite, Quad or other node invoking the shader 
// in the .scn file.

